#ifndef __TREE_FRAGMENT_HEADER__
#define __TREE_FRAGMENT_HEADER__

#include "globals.h"

class treeFragment : public DemoFX
{
private:
	static Texture* tree[2];
public:
	virtual void draw(float dt);
	static void prepareData();
};

Texture* treeFragment::tree[2];

inline void treeFragment::draw(float dt)
{
	alive = true;
	glPushAttrib(GL_ALL_ATTRIB_BITS);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

	glLoadIdentity();

	tree[0]->enable();
	tree[0]->bind();
	glColor4f(0,0,0,1);
	glBegin(GL_QUADS);
	glTexCoord2f(0,0); glVertex2f(-4,2);
	glTexCoord2f(1,0); glVertex2f(0, 2);
	glTexCoord2f(1,1); glVertex2f(0, -3);
	glTexCoord2f(0,1); glVertex2f(-4, -3);
	glEnd();

	glPushMatrix();
	glTranslatef(5, 0, 0);
	glBegin(GL_QUADS);
	glTexCoord2f(0,0); glVertex2f(-4,2);
	glTexCoord2f(1,0); glVertex2f(0, 2);
	glTexCoord2f(1,1); glVertex2f(0, -3);
	glTexCoord2f(0,1); glVertex2f(-4, -3);
	glEnd();
	glPopMatrix();
	
	glPushMatrix();
	tree[1]->bind();
	glTranslatef(3, 0, 0);
	glBegin(GL_QUADS);
	glTexCoord2f(0,0); glVertex2f(-4,2);
	glTexCoord2f(1,0); glVertex2f(0, 2);
	glTexCoord2f(1,1); glVertex2f(0, -3);
	glTexCoord2f(0,1); glVertex2f(-4, -3);
	glEnd();
	glPopMatrix();

	glPopAttrib();
}

inline void treeFragment::prepareData()
{
	tree[0] = new Texture("data/tr1.png");
	tree[1] = new Texture("data/tr2.png");
}


#endif
