#ifndef __GL_TEXT_HEADER__
#define __GL_TEXT_HEADER__

#include <iostream>
#include <fstream>
#include <GL/glfw.h>
#include "Texture.h"
#include "algebra.h"

using namespace std;

class glText
{
private:
	vec2 table[256];
	int metrics[256];
	Texture* tex;
public:
	glText(const char* fontImageFile, const char* fontMetricsFile);
	~glText() { if (tex) delete tex; }
	void print(float x, float y, float height, const char* text, ...);
};



inline glText::glText(const char* fontImageFile, const char* fontMetricsFile)
{
	tex = new Texture(fontImageFile);
	ifstream F(fontMetricsFile);
	for (int i = 0; i < 256; i++) F >> metrics[i];
	F.close();
	int k = 0;
	for (int i = 0; i < 16; i++)
		for (int j = 0; j < 16; j++, k++) 
			//table[k] = vec2((float)j / 16.0, 1.0 -(float)i / 16.0 - 0.0625);
			table[k] = vec2((float)j / 16.0, i / 16.0);
}

inline void glText::print(float x, float y, float height, const char* text, ...)
{
	if (!text) return;
	char buf[256];
	va_list ap;
	va_start(ap, text);
	vsprintf(buf, text, ap);
	va_end(ap);

	glPushAttrib(GL_COLOR_BUFFER_BIT | GL_ENABLE_BIT);
	glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glEnable(GL_TEXTURE_2D);
	glDisable(GL_LIGHTING);
	glDisable(GL_DEPTH_TEST);
	glDisable(GL_CULL_FACE);

	glPushMatrix();
	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();
	int wx, wy;
	glfwGetWindowSize(&wx, &wy);
	glOrtho(0, wx, 0, wy, -1, 1);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();

	//
	glTranslatef(x, y, 0);
	glScalef(height, height, 1);
	tex->bind();
	for (int i = 0; i < strlen(buf); i++) {
		int j = (int)buf[i];
		float xx = table[j][0];
		float yy = table[j][1];
		float d = (0.5 / 16.0) * (float)metrics[j];
		float dd = d * 0.0625;
		glBegin(GL_QUADS);
		glTexCoord2f(xx, yy + 0.0625); glVertex2f(0, 0);
		glTexCoord2f(xx + dd, yy + 0.0625); glVertex2f(d, 0);
		glTexCoord2f(xx + dd, yy); glVertex2f(d, 1);
		glTexCoord2f(xx, yy); glVertex2f(0, 1);
		glEnd();
		glTranslatef(metrics[j] * (0.5 / 16.0), 0, 0);
	}

	glMatrixMode(GL_PROJECTION);
	glPopMatrix();
	glMatrixMode(GL_MODELVIEW);
	glPopMatrix();

	glPopAttrib();
}

#endif

