#include "creditPart.h"

Texture* creditPart::credit;
glModel* creditPart::model;

void creditPart::prepareData()
{
	credit = new Texture("data/image1.png", Texture::TEXTURE_2D, Texture::LINEAR);
	model = new glModel("data/biot2.data");
    model->group[2].setColor(col[6][0], col[6][1], col[6][2], 1.0);
    model->group[0].setColor(col[10][0], col[10][1], col[10][2], 1.0);
    model->group[1].setColor(col[7][0], col[7][1], col[7][2], 1.0);
}


void creditPart::drawBiot(float dt)
{
    for (int i=0; i<N; i++)
    {
        glPushMatrix();
        glRotatef(node[i].rot[0], 1, 0, 0);
        glRotatef(node[i].rot[1], 0, 1, 0);
        glRotatef(node[i].rot[2], 0, 0, 1);
        
        glRotatef(glfwGetTime()*40.0, 1, 0, 0);
        glRotatef(node[i].x, 0, 1, 0);
        glTranslatef(0.4, 0,0);
        if (node[i].incr) {
            node[i].x += dt;
            if (node[i].x > 90.0) node[i].incr=false;
        } else {
            node[i].x -= dt;
            if (node[i].x < 0.0) node[i].incr=true;
        }
        model->draw();
        glPopMatrix();
    }
}


void creditPart :: init (void)
{
	//credit = new Texture("data/image1.png", Texture::TEXTURE_2D, Texture::LINEAR);
	//model = new glModel("data/biot2.data");
    for (int i=0; i<N; i++) {
        node[i].rot=vec3(frnd()*360, frnd()*360, frnd()*360);
        node[i].x=frnd()*90;
        node[i].incr=true;                             
    }
	//model->group[0].setColor(1,0,0,1);
	startTime = glfwGetTime();
}

void creditPart::draw(float dt)
{
	glPushAttrib(GL_ALL_ATTRIB_BITS);

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective(60.0, 4.0/3.0, 0.1, 1000.0);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	gluLookAt(-3,0,5, 1.0,0,0, 0,1,0);

	glEnable(GL_FOG);
	glDisable(GL_BLEND);
	glEnable(GL_LIGHTING);
	glEnable(GL_DEPTH_TEST);
	glEnable(GL_LIGHT0);
	glDisable(GL_TEXTURE_2D);
	glEnable(GL_CULL_FACE);
	glFogi(GL_FOG_MODE, GL_LINEAR);
	static float Fog_Color[4] = {col[0][0], col[0][1], col[0][2], 1.0};
	glFogfv(GL_FOG_COLOR, Fog_Color);
	float t = glfwGetTime() - startTime;
	float f0 = 2.3;
	float f1 = 8.0;
	if (t < 6.0) {
		f0 = t/6.0 * 2.3;
		f1 = t/6.0 * 8.0;
	}
	glFogf(GL_FOG_START, f0);
	glFogf(GL_FOG_END, f1);
	static float Mat_Specular[4] = {1.0, 1.0, 1.0, 1.0};
	static float Mat_Ambient[4] = {0.5, 0.5, 0.5, 1.0};
	static float Mat_Diffuse[4] = {1.0, 1.0, 1.0, 1.0};
	static float Mat_Shininess = 100.0;
	glMaterialfv(GL_FRONT, GL_AMBIENT, Mat_Ambient);
	glMaterialfv(GL_FRONT, GL_DIFFUSE, Mat_Diffuse);
	glMaterialfv(GL_FRONT, GL_SPECULAR, Mat_Specular);
	glMaterialf(GL_FRONT, GL_SHININESS, Mat_Shininess);
	glEnable(GL_COLOR_MATERIAL);
	
	drawBiot(dt*4.5);

	glDisable(GL_FOG);
	glDisable(GL_LIGHTING);

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glOrtho(0, 640, 0, 480, -1, 1);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();

	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glDisable(GL_DEPTH_TEST);
	if (t < 6.0) glColor4f(0.5, 0.5, 0, 0.7 * t/6.0);
	else glColor4f(0.5,0.5,0,0.7);
	credit->enable();
	credit->bind();
	glPushMatrix();
	glTranslatef(384, 480-352, 0);
	glBegin(GL_QUADS);
	glTexCoord2f(0,1); glVertex2f(0,0);
	glTexCoord2f(1,1); glVertex2f(255, 0);
	glTexCoord2f(1,0); glVertex2f(255, 255);
	glTexCoord2f(0,0); glVertex2f(0, 255);
	glEnd();
	glPopMatrix();
	credit->disable();

	glPopAttrib();
}

void creditPart::done()
{
	delete credit;
	delete model;
}

